<?php
/* --------------------------------------------------------------
 PluginRegistryService.php 2020-03-12
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\Plugins\Implementation;

use Gambio\Core\Application\Plugins\PluginRegistryService as PluginRegistryServiceInterface;

/**
 * Class PluginRegistryService
 * @package Gambio\Core\Application\Plugins
 */
class PluginRegistryService implements PluginRegistryServiceInterface
{
    /**
     * @var PluginsLoader
     */
    private $loader;
    
    /**
     * @var PluginsCache
     */
    private $cache;
    
    
    /**
     * PluginRegistryService constructor.
     *
     * @param PluginsLoader $loader
     * @param PluginsCache  $cache
     */
    public function __construct(PluginsLoader $loader, PluginsCache $cache)
    {
        $this->loader = $loader;
        $this->cache  = $cache;
    }
    
    
    /**
     * @inheritDoc
     */
    public function get(): array
    {
        return $this->cache->get();
    }
    
    
    /**
     * @inheritDoc
     */
    public function exists(): bool
    {
        return $this->cache->has();
    }
    
    
    /**
     * @inheritDoc
     */
    public function rebuild(): void
    {
        if ($this->cache->has()) {
            $this->cache->delete();
        }
        
        $pluginsCache = $this->loader->load();
        $this->cache->set($pluginsCache);
    }
    
    
    /**
     * @inheritDoc
     */
    public function delete(): void
    {
        $this->cache->delete();
    }
}